/**
 * Created by dprevost on 9/22/2014.
 */

//simple mimic of the jQuery callbacks function that allows you to maintain a list of callback functions
function Callbacks() {

    var _callbacks = [];

    this.add = function(callback) {
            if(this.has(callback)){ return;}

            _callbacks.push(callback);
        };
    this.fire = function(param) {
            for(var i=0; i<_callbacks.length; ++i) {
                _callbacks[i].apply(this, arguments);
            }
        };
    this.has = function(callback) {
            var has = false;
            for(var i=0; i<_callbacks.length; ++i) {
                if(callback === _callbacks[i]){ return true;}
            }
            return has;
        };
    this.remove = function(callback) {
            for(var i=0; i<_callbacks.length; ++i) {
                if(callback === _callbacks[i]) {
                    _callbacks.splice(i, 1);
                }
            }
        };
    this.empty = function() {
            _callbacks = [];
        }
}