/**
 * Created by jdziezanowski on 7/23/2015.
 */


var cbNavigate = function() {
	var currTour = hopscotch.getCurrTour();
	var stepNum = hopscotch.getCurrStepNum();
	var step = currTour.steps[stepNum];
	//alertify.success(stepNum + ": " + step.title);
	if (step) {
		if (step.page) {
			PAGE_SERVICE.selectPage(step.page);
		}

		var $el = $();

		if (step.target.startsWith(".")) {
			$el = $(step.target);
		} else {
			$el = $("#" + step.target);
		}
		// var $panel = $el.parents(".widget-panel");
		//note: with Chrome 61+ jQuery.scrollTo() is no longer functional
		$el.get(0).scrollIntoView({"behavior": "smooth"});

	}
};

var cbError = function() {
};

hopscotch.registerHelper("cbNavigate", cbNavigate);
hopscotch.registerHelper("cbError", cbError);


var startTour = function() {
	var translateIf = function(s) {
		if (_.isString(s) && s.indexOf("KEY_") === 0) {
			return TRANSLATE_SERVICE.instant(s);
		} else {
			return s;
		}
	};
	ajax.get("/WebLink/tour.json?cb="+Math.random(), {}, function(data, status){
		if (status === 200 && typeof(data) !== "undefined" && data.length > 0) {
			var tour = JSON.parse(data);
			if (tour.i18n) {
				tour.i18n.nextBtn = translateIf(tour.i18n.nextBtn);
				tour.i18n.prevBtn = translateIf(tour.i18n.prevBtn);
				tour.i18n.doneBtn = translateIf(tour.i18n.doneBtn);
				tour.i18n.skipBtn = translateIf(tour.i18n.skipBtn);
				tour.i18n.closeTooltip = translateIf(tour.i18n.closeTooltip);
			}
			if (tour && _.isArray(tour.steps)) {
				$.each(tour.steps, function(index, step) {
					step.content = translateIf(step.content);
					step.title = translateIf(step.title);
				});
			}
			hopscotch.startTour(tour, $GET('TOUR_START_STEP',0));
		}
	});
};

