
var $TRACE = function(msg) {
	//if (alertify) {
	//	alertify.message(msg);
	//}
	//console.log(msg);
};

var CACHE_BUST = ""; // global cache bust string

function loadManifest(username, role) { // optional parameters used when account management is active

	var progress = document.getElementById('splash-progress-info');
	//var CACHE_BUST = "";


	var progressTotal = 0;
	var progressIndex = 0;

	function updateProgressBar(total, count, msg){
		if (total == 0) return;
		msg = msg || "";
		var percent=Math.ceil((count*100)/total);
		document.getElementById("splash-progress-bar").style.width=percent+'%';
		if ($GET("SHOW_LOADING_FILENAMES", false)){
			document.getElementById("splash-progress-bar-info").innerHTML=msg;
		} else {
			document.getElementById("splash-progress-bar-info").innerHTML = percent+'%';
		}
		document.getElementById('splash-progress').style.opacity = 0.8;
	}

	function sleep(millis) {
		if (millis == 0) return;
		var date = new Date();
		var curDate = null;
		do {
			curDate = new Date();
		}
		while (curDate - date < millis);
	}

	var splashMsg = function (msg) {
		progress.innerHTML = msg;
		updateProgressBar(progressTotal, progressIndex, msg);
		sleep(0);
	};

	var CSSDone = function(msg) {
		alert(msg);
	};

	function handleCssLoaded(link) {
		// MAGIC
		// #1
		link.onload = function () {
			CSSDone('onload listener');
		};
		// #2
		if (link.addEventListener) {
			link.addEventListener('load', function() {
				CSSDone("DOM's load event");
			}, false);
		}
		// #3
		link.onreadystatechange = function() {
			var state = link.readyState;
			if (state === 'loaded' || state === 'complete') {
				link.onreadystatechange = null;
				CSSDone("onreadystatechange");
			}
		};

		// #4
		var cssnum = document.styleSheets.length;
		var ti = setInterval(function() {
			if (document.styleSheets.length > cssnum) {
				// needs more work when you load a bunch of CSS files quickly
				// e.g. loop from cssnum to the new length, looking
				// for the document.styleSheets[n].href === url
				// ...

				// FF changes the length prematurely :()
				CSSDone('listening to styleSheets.length change');
				clearInterval(ti);

			}
		}, 10);
	}


	function loadCss(id, url) {
		try {
			var link = document.createElement("link");
			link.type = "text/css";
			link.rel = "stylesheet";
			link.href = url+CACHE_BUST;
			if (id.length>0) {
				link.setAttribute('id', id);
			}
			//handleCssLoaded(link);
			document.getElementsByTagName("head")[0].appendChild(link);
		}
		catch (e) {
			alert(e.message);
		}
	}

	var configFiles = [

	];

	var configObj = {};

	var storeAccountInConfig = function(username, role) {
		configObj.user = {
			"username": username,
			"role": role
		}
	}

	if (username != null && role != null && username.length > 0 && role.length > 0) {  // account management is active
		storeAccountInConfig(username, role);
	}

	var loadConfig = function(doneCallback) {
		var index = 0;

		function onJSONLoaded(src) {
			splashMsg(src);
			index = index + 1;
			progressIndex = progressIndex + 1;
			sleep(10);

			if (index < configFiles.length) {
				loadNextJSON();
			} else {
				splashMsg("CONFIG loaded");
				doneCallback();
			}
		}

		function loadNextJSON()  {

			var src = configFiles[index].src;
			var name = configFiles[index].name;
			if (src[0]=='~') { // ~ means comment
				onJSONLoaded(src);
			} else {
				//debugger;
				var json;
				$.getJSON(src+CACHE_BUST, function (json) {
					configObj[name] = json;
				}).always(function() {
					onJSONLoaded(src);
				});
			}
		}

		loadNextJSON();

	};


	var loadStyles = function(doneCallback) {

		var index = 0;


		var manifest = configObj.stylesManifest.manifest;
		if (manifest) {
			function onStyleLoaded(src) {
				splashMsg(src);
				index = index + 1;
				progressIndex = progressIndex + 1;

				sleep(0);

				if (index < manifest.length) {
					loadNextStyle();
				} else {
					splashMsg("load complete");
					document.getElementById('splash-progress').style.opacity = 0;
					doneCallback();
				}
			}

			function loadNextStyle()  {

				var src = manifest[index];
				var id = "";
				if (typeof(src) == "object") {
					id = src.id || "";
					src = src.src || "";
				}
				if (src[0]=='~') { // ~ means comment
					onStyleLoaded(src);
				} else {

					//if (src.length > 0) {
					//	head.load(src + CACHE_BUST, function () {
					//		onStyleLoaded(src);
					//	});
					//} else {
						loadCss(id, src);
						onStyleLoaded(id);
					//}
				}
			}

			loadNextStyle();
		}

	};

	var loadScripts = function(doneCallback) {

			var index = 0;

			var manifest = configObj.scriptManifest.manifest;
			if (manifest) {
				function onFileLoaded(src) {
					splashMsg(src);
					index = index + 1;
					progressIndex = progressIndex + 1;
					sleep(0);

					if (index < manifest.length) {
						loadNextFile();
					} else {
						splashMsg("load complete");
						doneCallback();
					}
				}

				function loadNextFile()  {

					var src = manifest[index];
					if (src[0]=='~') { // ~ means comment
						onFileLoaded(src);
					} else {
						//debugger;
						head.load(src+CACHE_BUST, function () {
							onFileLoaded(src);
						});
					}
				}

				loadNextFile();
			}

	};

	var doInitialLayout = function() {
		var bannerHeight = $(".banner").outerHeight(true);
		$(".app-body").css("top", bannerHeight+"px");
	};

	var loadAssets = function(doneCallback) {
		var preloadAsset = function(assets, callback) {
			var loaded  = 0;
			var src;
			for(var i = 0; i < assets.length; i++) {
				var img = new Image();
				src = assets[i];
				img.onload = function() {

					progressIndex = progressIndex + 1;
					splashMsg(this.src);

					if(++loaded == assets.length && callback) {
						callback();
					}
				};
				img.onerror = function() {
					//alert("no asset " + this.src);

					if(++loaded == assets.length && callback) {
						callback();
					}
				};
				img.src = src+CACHE_BUST;
			}

		};

		preloadAsset(configObj.assetManifest.fileList, function() {
			doneCallback();
		});
	};
	
	var loadAppManifest = function(callback) {
		$.getJSON('manifest.app.json?cb='+Math.random(), function(data) {
			configObj.appInfo = {
				version : data.version || 'dev',
				versionDesc : data.versionDesc || 'Development Version'
			};
			CACHE_BUST = "?ver=" + configObj.appInfo.version;
			configFiles = configObj.appManifest = data.manifest;
			$('#app-version').text("Version " + configObj.appInfo.version);
			$('#app-version-desc').text(configObj.appInfo.versionDesc);
			callback();
		});
	};


	// settings already loaded in index.html
	//$SETTINGS.loadSettings(function() {
		updateProgressBar(100,0);
		loadAppManifest(function() {
			loadConfig(function () {
				// get a list of asset src paths and stash in config object
				var root = configObj.assetManifest.root;
				var assetList = [];
				var manifestObj = configObj.assetManifest.manifest;
				for (var name in manifestObj) {
					if (manifestObj.hasOwnProperty(name)) {
						assetList.push(root + manifestObj[name]);
						manifestObj[name]=manifestObj[name]+CACHE_BUST;
					}
				}
				configObj.assetManifest.fileList = assetList;
				progressTotal =
					configFiles.length +
					configObj.scriptManifest.manifest.length +
					configObj.stylesManifest.manifest.length +
					configObj.assetManifest.fileList.length;
				loadStyles(function () {
					loadAssets(function () {
						loadScripts(function () {
							//doInitialLayout();
							var configModule = angular.module("CONFIG", []);
							configModule.constant("CONFIG", configObj);

							angular.bootstrap(document, ['tux']);//, { strictDi: true});
						});
					});
				});
			});
		});
	//});

}


